#!/usr/bin/env python
# -*- coding: utf-8 -*-

# ###########################################################
# Minimal-Demonstrator für die OSMscr3-Klasse.
#
# Detlev Ahlgrimm, 2017
#
# 02.2022   D.A.    minimaler Umbau zwecks Nutzung in wxZ3D-OSM.


import wx               # python-wxWidgets-2.8.12.1-10.4.1.x86_64
import os
#import time
from OSMscr3 import OSMscr3
from OSMhelper import OSMhelper

VERSION="1.1"

HOME_DIR=os.path.expanduser('~')
SOURCE={
  "OSM"   : { "tile_url"  : "http://tile.openstreetmap.org/{z}/{x}/{y}.png",
              "tile_size" : 256,
              "max_zoom"  : 19,
              "cache_dir" : os.path.join(HOME_DIR, "wd", "osm")
            },
  "OCM"   : { "tile_url"  : "https://tile.thunderforest.com/cycle/{z}/{x}/{y}.png?apikey=0ab849f67c69480eb29423a2fb809625",
              "tile_size" : 256,
              "max_zoom"  : 18,
              "cache_dir" : os.path.join(HOME_DIR, "wd", "ocm")
            },
        }
SERVER="OSM"

class MapWindow(wx.Window):
  def __init__(self, parent, centerLL, zoom, border, title, size):
    wx.Window.__init__(self, parent)
    self.parent=parent
    self.centerLL=centerLL
    self.zoom=zoom
    self.border=border
    self.Bind(wx.EVT_PAINT,         self.onPaint)
    self.Bind(wx.EVT_LEFT_DOWN,     self.onLeftDown)
    self.Bind(wx.EVT_LEFT_UP,       self.onLeftUp)
    self.Bind(wx.EVT_MOTION,        self.onMotion)
    self.Bind(wx.EVT_MOUSEWHEEL,    self.onMouseWheel)
    self.Bind(wx.EVT_SIZE,          self.onSize)
    self.Bind(wx.EVT_TIMER,         self.onTimer)
    self.osm=OSMscr3(SOURCE[SERVER])
    self.dc_sizeXY=self.parent.GetSize()
    self.timer_interval=500
    self.timer=wx.Timer(self)
    self.refresh_needed=False
    self.leftDown=False
    self.cross_posXY=None
    self.handle=self.osm.setup(self.dc_sizeXY, centerLL, self.zoom, self.border)
    self.hlp=OSMhelper()
    self.osm.setZoom(self.zoom, (0, 0))
    self.osm.setCenter(self.centerLL)

    self.timer.Start(self.timer_interval)
    self.Refresh()


  def onPaint(self, evt):
    new_bmp, (sx, sy)=self.osm.drawMap()
    if new_bmp:
      (w, h, bmpdata), (sx, sy), self.refresh_needed=self.osm.getBitmap()
      self.bmpbuf=wx.BitmapFromBuffer(w, h, bmpdata)
    dc=wx.PaintDC(self)
    dc.DrawBitmap(self.bmpbuf, sx, sy)

    if self.cross_posXY:
      dc.SetPen(wx.Pen("BLACK", 2))
      (x, y), s=self.cross_posXY, 10
      dc.DrawLineList([(x-s, y-s, x+s, y+s), (x-s, y+s, x+s, y-s)])


  def onLeftDown(self, evt):
    self.leftDown=True
    self.was_moved=False
    self.leftDownPosXY=evt.GetPosition()
    self.SetCursor(wx.StockCursor(wx.CURSOR_HAND))
    print("Klick:", self.osm.getLatLonForPixel(self.leftDownPosXY))


  def onLeftUp(self, evt):
    self.leftDown=False
    self.SetCursor(wx.StockCursor(wx.CURSOR_ARROW))
    if self.was_moved:
      self.osm.endMoveMap()
      self.Refresh()


  def onMotion(self, evt):
    data=self.osm.getDataForPoint(evt.GetPosition())      
    if len(data)>0:
      print(data)
    if self.leftDown:
      self.was_moved=True
      scroll_distXY=self.leftDownPosXY-evt.GetPosition()
      self.osm.doMoveMap(scroll_distXY)
      self.Refresh()


  def onMouseWheel(self, evt):
    zoom_old=self.zoom
    if evt.GetWheelRotation()>0:
      self.zoom=min(SOURCE[SERVER]["max_zoom"], self.zoom+1)
    else:
      self.zoom=max(0, self.zoom-1)
    if self.zoom!=zoom_old:
      self.osm.setZoom(self.zoom, evt.GetPosition())
      self.Refresh()


  def onSize(self, evt):
    try:
      self.dc_sizeXY=self.GetSize()
      self.osm.setSize(self.dc_sizeXY)
    except:
      pass  # der allererste EVT_SIZE kommt gerne mal, bevor self.osm existiert


  def onTimer(self, evt):
    if self.refresh_needed:
      self.Refresh()

  # ######################################################################
  # Stellt ein Kreuz an der 
  def drawCross(self, posXY, size=10):
    self.dc.SetPen(wx.Pen("BLACK", 2))
    (x, y), s=posXY, size
    self.dc.DrawLineList([(x-s, y-s, x+s, y+s), (x-s, y+s, x+s, y-s)])

  def centerPos(self, lat, lon):
    self.centerLL=(lat, lon)
    self.cross_posXY=self.dc_sizeXY[0]/2, self.dc_sizeXY[1]/2
    self.osm.setCenter(self.centerLL)
    self.Refresh()


class MapFrame(wx.Frame):
  def __init__(self, parent, centerLL, zoom, border, title, pos=wx.DefaultPosition, size=wx.DefaultSize):
    wx.Frame.__init__(self, None, wx.ID_ANY, title+" "+VERSION, pos=pos, size=size)
    self.win=MapWindow(self, centerLL, zoom, border, title, size)

  def centerPos(self, lat, lon):
      self.win.centerPos(lat, lon)

  def loadTrack(self, track):
      self.win.osm.loadTrack(track)
