#! /usr/bin/env python3
# -*- coding: utf-8 -

# geo_converter.py
#
# https://rechneronline.de/geo-koordinaten/#umrechnung
# https://pro.arcgis.com/de/pro-app/latest/tool-reference/data-management/convert-coordinate-notation.htm
#
# D.Ahlgrimm    13.02.2022

import os
import sys
import datetime
import time



class GeoConverter():
    def __init__(self):
        pass

    # ----------------------------------------------------------------------
    # Liefert zu einer Koordinate in "Grad + Dezimalminuten"
    # den entsprechenden Wert in "Dezimalgrad".
    def ddm2dd(self, ddmf, d):
        if isinstance(ddmf, str):
            ddmf=float(ddmf)
        if d.upper() in ("S", "W"):
            ddmf=-ddmf
        ddm = ddmf/100.0
        d = int(ddm)
        m = int((ddm-d)*100)
        s = round((((ddm-d)*100)-m)*60, 4)
        return round(d+m/60.0+s/3600.0, 6)

# ----------------------------------------------------------------------
# Tests
if __name__=="__main__":
    gc=GeoConverter()

    print(gc.ddm2dd('5448.2363', 'N'), gc.ddm2dd('931.2752', 'E'))
