#!/usr/bin/env python
# -*- coding: utf-8 -*-

# ###########################################################
# Minimal-Demonstrator für die OSMscr3-Klasse.
#
# Detlev Ahlgrimm, 2017


import wx               # python-wxWidgets-2.8.12.1-10.4.1.x86_64
import os
#import time
from OSMscr3 import OSMscr3
from OSMhelper import OSMhelper

VERSION="1.1"

HOME_DIR=os.path.expanduser('~')
SOURCE={
  "OSM"   : { "tile_url"  : "http://tile.openstreetmap.org/{z}/{x}/{y}.png",
              "tile_size" : 256,
              "max_zoom"  : 19,
              "cache_dir" : os.path.join(HOME_DIR, "wd", "osm")
            },
  "OCM"   : { "tile_url"  : "https://tile.thunderforest.com/cycle/{z}/{x}/{y}.png?apikey=0ab849f67c69480eb29423a2fb809625",
              "tile_size" : 256,
              "max_zoom"  : 18,
              "cache_dir" : os.path.join(HOME_DIR, "wd", "ocm")
            },
        }
SERVER="OSM"

class MapWindow(wx.Window):
  def __init__(self, parent, centerLL, zoom, border, title, size):
    wx.Window.__init__(self, parent)
    self.parent=parent
    self.centerLL=centerLL
    self.zoom=zoom
    self.border=border
    self.Bind(wx.EVT_PAINT,         self.onPaint)
    self.Bind(wx.EVT_LEFT_DOWN,     self.onLeftDown)
    self.Bind(wx.EVT_LEFT_UP,       self.onLeftUp)
    self.Bind(wx.EVT_MOTION,        self.onMotion)
    self.Bind(wx.EVT_MOUSEWHEEL,    self.onMouseWheel)
    self.Bind(wx.EVT_SIZE,          self.onSize)
    self.Bind(wx.EVT_TIMER,         self.onTimer)
    self.osm=OSMscr3(SOURCE[SERVER])
    self.dc_sizeXY=self.parent.GetSize()
    self.timer_interval=500
    self.timer=wx.Timer(self)
    self.refresh_needed=False
    self.leftDown=False
    self.handle=self.osm.setup(self.dc_sizeXY, centerLL, self.zoom, self.border)
    self.hlp=OSMhelper()
    self.osm.setZoom(self.zoom, (0, 0))
    self.osm.setCenter(self.centerLL)

    self.point_list=[
      ( (54.79167946079812, 9.442416429519653), 5,  (255, 0, 0),   (99, " Hackspace ")),
      ( (54.80507860419667, 9.52488899230957),  8,  (255, 215, 0), (99, " Zuhause\n ist es am schönsten ")),
      ( (54.80737577256639, 9.513548612594604), 5,  (255, 0, 0),   (99, " lecker\n Bier-Versorger "))  ]
    
    #self.point_list=[
    #  ( (54.804663, 9.522030), 5,  (255, 0, 0),   (99, " AAA ")),
    #  ( (54.804753, 9.522186), 5,  (255, 0, 0),   (99, " BBB ")) ]
    self.osm.loadPoints(self.point_list)

    self.track=[
      ((54.80506000, 9.524430000), 10), ((54.80547000, 9.524410000), 10), ((54.80574000, 9.524520000), 10),
      ((54.80592000, 9.523740000), 10), ((54.80602000, 9.523490000), 10), ((54.80608000, 9.523380000), 10), 
      ((54.80654000, 9.523080000), 10), ((54.80688000, 9.522800000), 10), ((54.80719000, 9.522640000), 10), 
      ((54.80732000, 9.522600000), 10), ((54.80734000, 9.522480000), 10), ((54.80734000, 9.522470000), 10), 
      ((54.80675000, 9.519840000), 10), ((54.80646000, 9.518640000), 10), ((54.80643000, 9.518360000), 10), 
      ((54.80643000, 9.518070000), 10), ((54.80648000, 9.517230000), 10), ((54.80654000, 9.517230000), 10), 
      ((54.80658000, 9.517170000), 10), ((54.80660000, 9.517090000), 10), ((54.80658000, 9.517000000), 10), 
      ((54.80655000, 9.516940000), 10), ((54.80661000, 9.516750000), 10), ((54.80664000, 9.515510000), 10), 
      ((54.80666000, 9.514950000), 10), ((54.80674000, 9.514230000), 10), ((54.80683000, 9.514210000), 10), 
      ((54.80690000, 9.514180000), 10), ((54.80706000, 9.514170000), 10), ((54.80709000, 9.513930000), 10), 
      ((54.80716000, 9.513420000), 10), ((54.80729000, 9.513460000), 10)]
    self.osm.loadTrack(self.track)

    self.timer.Start(self.timer_interval)
    self.Refresh()


  def onPaint(self, evt):
    new_bmp, (sx, sy)=self.osm.drawMap()
    if new_bmp:
      (w, h, bmpdata), (sx, sy), self.refresh_needed=self.osm.getBitmap()
      self.bmpbuf=wx.BitmapFromBuffer(w, h, bmpdata)
    dc=wx.PaintDC(self)
    dc.DrawBitmap(self.bmpbuf, sx, sy)


  def onLeftDown(self, evt):
    self.leftDown=True
    self.was_moved=False
    self.leftDownPosXY=evt.GetPosition()
    self.SetCursor(wx.StockCursor(wx.CURSOR_HAND))
    print("Klick:", self.osm.getLatLonForPixel(self.leftDownPosXY))


  def onLeftUp(self, evt):
    self.leftDown=False
    self.SetCursor(wx.StockCursor(wx.CURSOR_ARROW))
    if self.was_moved:
      self.osm.endMoveMap()
      self.Refresh()


  def onMotion(self, evt):
    data=self.osm.getDataForPoint(evt.GetPosition())      
    if len(data)>0:
      print(data)
    if self.leftDown:
      self.was_moved=True
      scroll_distXY=self.leftDownPosXY-evt.GetPosition()
      self.osm.doMoveMap(scroll_distXY)
      self.Refresh()


  def onMouseWheel(self, evt):
    zoom_old=self.zoom
    if evt.GetWheelRotation()>0:
      self.zoom=min(SOURCE[SERVER]["max_zoom"], self.zoom+1)
    else:
      self.zoom=max(0, self.zoom-1)
    if self.zoom!=zoom_old:
      self.osm.setZoom(self.zoom, evt.GetPosition())
      self.Refresh()


  def onSize(self, evt):
    try:
      self.dc_sizeXY=self.GetSize()
      self.osm.setSize(self.dc_sizeXY)
    except:
      pass  # der allererste EVT_SIZE kommt gerne mal, bevor self.osm existiert


  def onTimer(self, evt):
    if self.refresh_needed:
      self.Refresh()



class MapFrame(wx.Frame):
  def __init__(self, parent, centerLL, zoom, border, title, pos=wx.DefaultPosition, size=wx.DefaultSize):
    wx.Frame.__init__(self, None, wx.ID_ANY, title+" "+VERSION, pos=pos, size=size)
    win=MapWindow(self, centerLL, zoom, border, title, size)



if __name__=="__main__":
  app=wx.App(False)
  frame=MapFrame(None, (54.805060, 9.524878), 15, (2, 2), "wxOSMmini", size=(1024, 768))
  frame.Show()
  app.MainLoop()
